/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.dynpack;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.data.OptionalLootItem;
import xfacthd.buddingcrystals.common.util.CrystalSet;

final class DynamicBlockLoot
extends BlockLoot {
    public void run(Map<ResourceLocation, String> cache) {
        HashMap<ResourceLocation, LootTable> built = new HashMap<ResourceLocation, LootTable>();
        this.accept((loc, builder) -> {
            if (!built.containsKey(loc)) {
                built.put((ResourceLocation)loc, builder.m_79165_(LootContextParamSets.f_81421_).m_79167_());
            }
        });
        built.forEach((loc, table) -> cache.put(new ResourceLocation(loc.m_135827_(), "loot_tables/" + loc.m_135815_() + ".json"), LootTables.m_79200_((LootTable)table).toString()));
    }

    protected Iterable<Block> getKnownBlocks() {
        return BCContent.loadedSets().stream().map(CrystalSet::blocks).flatMap(Collection::stream).toList();
    }

    protected void addTables() {
        BCContent.loadedSets().forEach(set -> {
            this.m_124165_(set.getBuddingBlock(), DynamicBlockLoot.m_124125_());
            this.m_124272_(set.getSmallBud());
            this.m_124272_(set.getMediumBud());
            this.m_124272_(set.getLargeBud());
            this.m_124175_(set.getCluster(), block -> DynamicBlockLoot.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)OptionalLootItem.lootTableItem((ItemLike)set.getDroppedItem()).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)set.getMaxDrops()))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_144323_)))).m_7170_((LootPoolEntryContainer.Builder)DynamicBlockLoot.m_124131_((ItemLike)block, (FunctionUserBuilder)OptionalLootItem.lootTableItem((ItemLike)set.getDroppedItem()).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)set.getNormalDrops())))))));
        });
    }
}

